import ConfigurationClient from './clients/copyfactory/configuration.client';
import HistoryClient from './clients/copyfactory/history.client';
import TradingClient from './clients/copyfactory/trading.client';
/**
 * MetaApi CopyFactory copy trading API SDK
 */
export default class CopyFactory {
    private _domain;
    private _httpClient;
    private _domainClient;
    private _configurationClient;
    private _historyClient;
    private _tradingClient;
    /**
     * Enables using Log4js logger with extended log levels for debugging instead of
     * console.* functions. Note that log4js configuration performed by the user.
     */
    static enableLog4jsLogging(): void;
    /**
     * Constructs CopyFactory class instance
     * @param {String} token authorization token
     * @param {Object} opts connection options
     * @param {String} [opts.domain] domain to connect to
     * @param {String} [opts.extendedTimeout] timeout for extended http requests in seconds
     * @param {Number} [opts.requestTimeout] timeout for http requests in seconds
     */
    constructor(token: string, opts?: any);
    /**
     * Returns CopyFactory configuration API
     * @returns {ConfigurationClient} configuration API
     */
    get configurationApi(): ConfigurationClient;
    /**
     * Returns CopyFactory history API
     * @return {HistoryClient} history API
     */
    get historyApi(): HistoryClient;
    /**
     * Returns CopyFactory trading API
     * @return {TradingClient} trading API
     */
    get tradingApi(): TradingClient;
}
